const MobEffectInstance = $药水效果实例
const hasCurio = (entity, curio) => {
    return $饰品.getCuriosHelper().findEquippedCurio(curio, entity).isPresent()
}
const harmonious_potionEffects = [
    { effect: "irons_spellbooks:blight", duration: 120, amplifier: 7 },
    { effect: "irons_spellbooks:rend", duration: 120, amplifier: 15 },
    { effect: "irons_spellbooks:slowed", duration: 120, amplifier: 5 },
    { effect: "goety:sapped", duration: 120, amplifier: 4 },
    { effect: "minecraft:weakness", duration: 120, amplifier: 0 }
]
const cursed_potionEffects = [
    { effect: "goety:doom", duration: 20, amplifier: 4 },
    { effect: "attributeslib:grievous", duration: 60, amplifier: 1 },
    { effect: "goety:ender_ground", duration: 120, amplifier: 0 }
]
const speed_charm_immunities = [
    "effect.minecraft.slowness",
    "effect.irons_spellbooks.slowed"
]
const heavy_shot_immunities = [
    "effect.minecraft.levitation",
    "effect.minecraft.slow_falling",
    "effect.goety.flimsy",
    "effect.goety.busted",
    "effect.goety.plunge",
    "effect.goety.tripping",
    "effect.goety.ender_flux",
    "effect.aquamirae.armor_decrease"
]
const bright_light_immunities = [
    "effect.minecraft.darkness",
    "effect.minecraft.blindness",
    "effect.goety.nyctophobia",
    "effect.goety.sense_loss"
]
const crown_immunities = [
    "effect.minecraft.darkness",
    "effect.minecraft.blindness",
    "effect.goety.sense_loss",
    "effect.goety.sapped",
    "effect.goety.cursed",
    "effect.goety.doom",
    "effect.goety.nyctophobia",
    "effect.goety.tangled",
    "effect.goety.arrowmantic",
    "effect.goety.wane",
    "effect.minecraft.weakness",
    "effect.minecraft.wither",
    "effect.minecraft.poison",
    "effect.minecraft.slowness",
    "effect.minecraft.mining_fatigue",
    "effect.minecraft.nausea",
    "effect.minecraft.hunger"
]
const burst_wiher_immunities = [
    "effect.minecraft.wither",
    "effect.minecraft.poison"
]
const beacon_potionEffects = [
    { effect: "minecraft:speed", duration: 260, amplifier: 1 },
    { effect: "minecraft:strength", duration: 260, amplifier: 1 },
    { effect: "minecraft:resistance", duration: 260, amplifier: 1 },
    { effect: "minecraft:haste", duration: 260, amplifier: 1 },
    { effect: "minecraft:regeneration", duration: 260, amplifier: 0 }
]
const crown_potionEffects = [
    { effect: "minecraft:speed", duration: 260, amplifier: 1 },
    { effect: "minecraft:strength", duration: 260, amplifier: 1 },
    { effect: "minecraft:resistance", duration: 260, amplifier: 1 },
    { effect: "minecraft:haste", duration: 260, amplifier: 1 },
    { effect: "minecraft:regeneration", duration: 260, amplifier: 0 },
    { effect: "minecraft:conduit_power", duration: 500, amplifier: 0 },
    { effect: "minecraft:night_vision", duration: 500, amplifier: 0 },
    { effect: "enigmaticlegacy:molten_heart", duration: 260, amplifier: 0 }
]
ServerEvents.tags('damage_type', event => {
    event.add('minecraft:bypasses_armor', 'advanced_creation:abyss_magic')
    event.add('minecraft:bypasses_enchantments', 'advanced_creation:abyss_magic')
    event.add('minecraft:bypasses_effects', 'advanced_creation:abyss_magic')
    event.add('minecraft:is_projectile', 'advanced_creation:abyss_magic')
    event.add('cataclysm:bypasses_hurt_time', '#forge:direct')
    event.add('cataclysm:bypasses_hurt_time', '#minecraft:is_lightning')
    
})
EntityEvents.hurt(event => {
    if (!event.entity) { return }
    if (!event.entity.isPlayer()) { return }
    let player = event.entity
    if (hasCurio(player, Item.of("kubejs:burst_wither_eye"))) {
        if (L2Hostility.sourceIs(event.source, "#minecraft:is_explosion") || L2Hostility.sourceIs(event.source, "minecraft:wither")) {
            event.cancel()
        }
    }
    if (player.getMainHandItem().getId() === 'advanced_creation:lightning_tofu' || player.getOffHandItem().getId() === 'advanced_creation:lightning_tofu') {
        if (L2Hostility.sourceIs(event.source, "#minecraft:is_fire") || L2Hostility.sourceIs(event.source, "#minecraft:is_lightning")) {
            event.cancel()
        }
    }
    
})
BlockEvents.rightClicked('minecraft:lightning_rod',event => {
    if (!event.getEntity()) { return }
    let player = event.getEntity()
    if (player.getMainHandItem().getId() === 'advanced_creation:lightning_tofu') {
        let lightning = event.level.createEntity('minecraft:lightning_bolt')
        lightning.setPosition(
            event.block.x + 0.5,
            event.block.y + 1,
            event.block.z + 0.5
        )
        lightning.spawn()
        if(!player.isFake()){
        player.addItemCooldown('advanced_creation:lightning_tofu',5)}
    }
})
ItemEvents.rightClicked('advanced_creation:lightning_tofu', event => {
    if (event.hand == "OFF_HAND") { return }
    let player = event.player
    let level = event.level
    let viewVector = player.getViewVector(1.0);
    let length = Math.sqrt(viewVector.x() * viewVector.x() + viewVector.y() * viewVector.y() + viewVector.z() * viewVector.z());
    let normalizedVector = {
    x: viewVector.x() / length,
    y: viewVector.y() / length,
    z: viewVector.z() / length
    }
    let spear = level.createEntity("cataclysm:lightning_spear")
    let damage = player.getAttributeValue('minecraft:generic.attack_damage')
    spear.setPosition(player.x, player.y + 1.6, player.z)
    let velocity = 2.8
    spear.setMotion(normalizedVector.x * velocity, normalizedVector.y * velocity, normalizedVector.z * velocity)
    spear.setOwner(player)
    spear.setDamage(damage*0.8)
    spear.mergeNbt({area_damage: damage*0.6,area_radius :1})
    spear.spawn()
    player.addItemCooldown('advanced_creation:lightning_tofu',15)
  })
EntityEvents.hurt(event => {
    if (!event.entity || event.entity.isPlayer()) { return }
    if (!event.entity.isAlive()) { return }
    if (event.getSource().getPlayer() == null) { return }
    let damageSource = event.getSource().getPlayer()
    if (!damageSource.isAlive()) { return } 
    if (hasCurio(damageSource, Item.of("kubejs:harmonious_magical_orb"))) {
        if (event.entity.potionEffects.getDuration("irons_spellbooks:blight") > 80 && event.entity.potionEffects.getDuration("irons_spellbooks:blight") < 130) { return }
        if (L2Hostility.sourceIs(event.source, "#forge:is_magic")) {
            harmonious_potionEffects.forEach(effect => {
                event.entity.potionEffects.add(effect.effect, effect.duration, effect.amplifier)
            })

        }

    }
    if (hasCurio(damageSource, Item.of("kubejs:deep_cursed_soul"))) {
        if (event.entity.potionEffects.getDuration("advanced_creation:fragile") > 50 && event.entity.potionEffects.getDuration("advanced_creation:fragile") < 65) { return }
        if (L2Hostility.sourceIs(event.source, "#advanced_creation:range")) {
            cursed_potionEffects.forEach(effect => {
                event.entity.potionEffects.add(effect.effect, effect.duration, effect.amplifier)
            })
            let ins = new MobEffectInstance("advanced_creation:fragile", 60, 0)
            event.entity.getActiveEffectsMap().put(ins.getEffect(), ins)

        }

    }
    if (hasCurio(damageSource, Item.of("kubejs:frozen_cold_core"))) {
        if (L2Hostility.sourceIs(event.source, "#forge:direct")) {
            event.entity.potionEffects.add("twilightforest:frosted", 100, 0)
            if (Math.random() < 0.5) {
                event.entity.potionEffects.add("goety:stunned", 80, 0)
            }
            if (Math.random() < 0.25) {
                let ins = new MobEffectInstance("l2complements:stone_cage", 50, 0)
                event.entity.getActiveEffectsMap().put(ins.getEffect(), ins)
            }

        }

    }
    if (hasCurio(damageSource, Item.of("kubejs:burst_mech_eye"))) {
        if (L2Hostility.sourceIs(event.source, "#minecraft:is_explosion") && !L2Hostility.sourceIs(event.source, "cataclysm:shredder")) {
            event.entity.potionEffects.add("attributeslib:grievous", 120, 1)
            event.entity.potionEffects.add("irons_spellbooks:rend", 120, 17)
        }
    }
}
)
NativeEvents.onEvent(Java.loadClass('net.minecraftforge.event.entity.living.LivingHurtEvent'), event => {
    if (!event.entity ||!event.entity.isAlive()) { return }
    if (event.getSource() === null) { return }
    if (!event.getSource().getPlayer()) { return }
    let player = event.getSource().getPlayer()
    
    if (hasCurio(player, Item.of("kubejs:heart_light"))) {
        if (L2Hostility.sourceIs(event.source, "#tacz:bullets")) {
            if(player.persistentData.heart_light_times <= 40){
                let health = player.getMaxHealth()
                let damage = event.getAmount()
                damage += health * 0.2
                event.setAmount(damage)
                player.persistentData.heart_light_times += 1
                }
        }
    }
    if (hasCurio(player, Item.of("kubejs:frozen_cold_core"))) {
        if (L2Hostility.sourceIs(event.source, "#forge:direct") && player.getMainHandItem().getId() !== 'goety:death_scythe') {
            let health = event.entity.getHealth()
            let damage = event.getAmount()
            damage += health * 0.005
            event.setAmount(damage)
        }
    }
})
NativeEvents.onEvent(1,false,Java.loadClass('net.minecraftforge.event.entity.living.LivingDamageEvent'), event => {
    if (!event.entity ||!event.entity.isAlive()) { return }
    if (event.getSource() === null) { return }
    if (!event.getSource().getPlayer()) { return }
    let player = event.getSource().getPlayer()
    let entity = event.entity
    let reduce = entity.getAttributeValue('l2damagetracker:damage_reduction')
    let absorp = entity.getAttributeValue('l2damagetracker:damage_absorption')
    if (hasCurio(player, Item.of("kubejs:mana_damage_glove"))) {
        let totalmana = player.getAttributeValue('irons_spellbooks:max_mana')
        let mana = $MagicData.getPlayerMagicData(player).getMana()

        if (totalmana >= 600 && mana >= totalmana * 0.5) {
            let damage = event.getAmount()
            let costmana = Math.min(Math.max(10, totalmana * 0.01), 30)
            damage += mana * 0.08
            if (absorp > 0) {damage += absorp}
            if (reduce > 0 && reduce < 1) {damage /= absorp}
            event.setAmount(damage)
            $MagicData.getPlayerMagicData(player).setMana(mana - costmana)
}
    }
})
NativeEvents.onEvent(Java.loadClass('net.minecraftforge.event.entity.living.MobEffectEvent$Applicable'), event => {
    if (event.getEntity().isPlayer()) {
        let isEquippedEffectCleanRing = hasCurio(event.getEntity(), Item.of("kubejs:speed_charm"))
        if (isEquippedEffectCleanRing) {
            if (speed_charm_immunities.includes(event.getEffectInstance().getEffect().getDescriptionId())) {
                event.setResult(0)
            }
        }
        if (hasCurio(event.getEntity(), Item.of("kubejs:heavy_shot"))) {
            if (heavy_shot_immunities.includes(event.getEffectInstance().getEffect().getDescriptionId())) {
                event.setResult(0)
            }
        }
        if (hasCurio(event.getEntity(), Item.of("kubejs:bright_light"))) {
            if (bright_light_immunities.includes(event.getEffectInstance().getEffect().getDescriptionId())) {
                event.setResult(0)
            }
        }
        if (hasCurio(event.getEntity(), Item.of("kubejs:burst_mech_eye"))) {
            if (burst_wiher_immunities.includes(event.getEffectInstance().getEffect().getDescriptionId())) {
                event.setResult(0)
            }
        }
        if (hasCurio(event.getEntity(), Item.of("kubejs:inspiration_crown"))) {
            if (crown_immunities.includes(event.getEffectInstance().getEffect().getDescriptionId())) {
                event.setResult(0)
            }
        }
    }
})
NativeEvents.onEvent(Java.loadClass('net.minecraftforge.event.entity.living.LivingDamageEvent'), event => {
    if (!event.entity || !event.entity.isPlayer()) { return }
    if (!event.entity.isAlive()) { return }

    let player = event.getEntity()

    
    if (hasCurio(player, Item.of("kubejs:heavy_shot"))) {

        let thisDamage = event.getAmount()
        if (L2Hostility.sourceIs(event.source, "#minecraft:bypasses_armor")) {
            thisDamage *= 0.8
        }
        event.setAmount(thisDamage)
    }
    if (hasCurio(player, Item.of("kubejs:harmonious_magical_orb"))) {

        let thisDamage = event.getAmount()
        if (L2Hostility.sourceIs(event.source, "#forge:is_magic")) {
            thisDamage *= 0.5
        }
        event.setAmount(thisDamage)
    }
    if (hasCurio(player, Item.of("kubejs:mana_shield")) ) {
        let halfDamage = event.getAmount() * 0.6
        let mana = $MagicData.getPlayerMagicData(player).getMana()
        if (halfDamage * 10 <= mana) {
            let leftmana = mana - Math.ceil(halfDamage*10)
            $MagicData.getPlayerMagicData(player).setMana(leftmana)
        } else {
            $MagicData.getPlayerMagicData(player).setMana(0)
            halfDamage -= mana/10
        }
        if (L2Hostility.sourceIs(event.source, "#forge:is_magic") && Math.random() < 0.5) { halfDamage = event.getAmount() }
        event.setAmount(event.getAmount() - halfDamage)
    }
    if (hasCurio(player, Item.of("kubejs:true_undead_eye")) && !hasCurio(player, Item.of("enigmaticlegacy:cursed_ring"))) {
        let reduce = player.getAttributeValue('l2damagetracker:damage_reduction')
        if (reduce <= 0 || L2Hostility.sourceIs(event.source, "#minecraft:bypasses_invulnerability")){ reduce = 1 }
        let finalDamage = event.getAmount() * reduce
        if (finalDamage > 10 && finalDamage > player.getHealth() * 0.5) {
            finalDamage = Math.max(10, player.getHealth() * 0.5)
            
      } else { return }
        finalDamage /= reduce
        event.setAmount(finalDamage)
    }

})
PlayerEvents.tick(event => {
    if (event.player.age % 20 === 0) {
        let player = event.player;

        if (!player || player.isSpectator()) {
            return;
        }
        if (hasCurio(player, Item.of("kubejs:bright_light"))){
            player.potionEffects.add("minecraft:night_vision", 500, 0, false, false)
        }
        if (hasCurio(player, Item.of("kubejs:beacon_necklace"))){
            beacon_potionEffects.forEach(effect => {
                player.potionEffects.add(effect.effect, effect.duration, effect.amplifier,false,false)
            })
        }
        if (hasCurio(player, Item.of("kubejs:conduit_charm"))){
            player.potionEffects.add("minecraft:conduit_power", 500, 0, false, false)
        }
        if (hasCurio(player, Item.of("kubejs:inspiration_crown"))){
            crown_potionEffects.forEach(effect => {
                player.potionEffects.add(effect.effect, effect.duration, effect.amplifier,false,false)
            })
        }
        if (hasCurio(player, Item.of("kubejs:heart_light"))){
            player.persistentData.putInt("heart_light_times",0)
        }
    } })

L2Hostility.newAttackListener()
.subscribeCreateSource(e => {
        try {
            if (L2Hostility.sourceIs(e, "#forge:direct")) {
                if (e.getAttacker().getMainHandItem().is("advanced_creation:lightning_tofu")) {
                    L2Hostility.enable(e, "bypass_armor")
                }
            }
            if (L2Hostility.sourceIs(e, "#forge:direct")) {
                if (e.getAttacker().getMainHandItem().is("kubejs:ice_tofu")) {
                    L2Hostility.enable(e, "bypass_armor")
                }
            }
            if (L2Hostility.sourceIs(e, "minecraft:arrow")) {
                if (e.getAttacker().getMainHandItem().is("irons_spellbooks:autoloader_crossbow")) {
                    L2Hostility.setTo(e, "advanced_creation:abyss_magic")
                }
            }
        } catch (ex) {
            console.log(ex)
        }
    }).register(10000)
